

  /*
   *  Object % CRYS_C2_Cipher    : %
   *  State           :  %state%
   *  Creation date   :  Feb. 20 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_C2_Cipher.c#1:csrc:
   *  \author R.Levin (using as templet the DES files of adams).
   *
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

/* .............. CRYS level includes ................. */

#include "DX_VOS_Mem.h"
#include "CRYS_C2_error.h"
#include "CRYS.h"

 
/************************ Defines **********************8***************/


/* canceling the PC-lint warning:
   Use of goto is deprecated */
/*lint --e{801} */

/************************ Enums *****************************************/

/************************ MACROS ****************************************/

/************************ Global Data ***********************************/

/************* Private function prototype *******************************/


/*****************************************************************************************************/
/**********                                Public Functions                                ***********/
/*****************************************************************************************************/

/*****************************************************************************************************/ 
/* 
 * @brief This function is used to initialize the C2 Cipher structures and mashine registers .
 *        In order to perform the C2 Cipher this function should be called first.
 *
 *        The function executes the following major steps:
 *
 *        1. Validating all of the inputs of the function. If one of the received 
 *           parameters is not valid it shall return an error:
 *            - verifying that the context pointer is not DX_NULL (*ContextID_ptr).
 *            - verifying that the pointer to the key buffer is not DX_NULL. 
 *            - verifying the value of the operation mode is valid . 
 *        2. Capturing the working context by calling the CRYS_CCM_GetContext().
 *        3. Initializing the working context by the following:
 *            - loading the key.
 *            - loading the control field 
 *            - loading the operation mode. 
 *            - loading the DecryptEncrypt flag .
 *        4. Encrypting the information in the working context and storing it to the 
 *           users received context. After then the working context is released.
 *           This state is operated by calling the CRYS_CCM_EncryptAndReleaseContext call.
 *        5. Exit the handler with the OK code.
 *      
 *
 * @param[in] ContextID_ptr - A pointer to the context buffer allocated by the user that
 *                            is used for the C2 Cipher operations.
 *
 * @param[in] Key_ptr -  A pointer to the users key buffer.
 *
 * @param[in] EncryptDecryptFlag - This flag determains if the C2 shall perform an Encrypt 
 *                                 operation [0] or a Decrypt operation [1].
 *
 * @param[in] OperationMode - The operation mode : ECB or CBC.
 * 
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value MODULE_* CRYS_C2_error.h
 */

CEXPORT_C CRYSError_t  CRYS_C2_CipherInit( 
                            CRYS_C2CipherUserContext_t    *ContextID_ptr,
                            CRYS_C2_Key_t                 *Key_ptr,
                            CRYS_C2_EncryptMode_t          EncryptDecryptFlag,
                            CRYS_C2_OperationMode_t        OperationMode )
{
   /* FUNCTION DECLERATIONS */

   /* The return error identifier */
   CRYSError_t Error;
   
  
   /* FUNCTION LOGIC */
   
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;
  
   
   return Error;
   
   
}/* END OF CRYS_C2_CipherInit */ 
  

/*****************************************************************************************************/                         
/** 
 * @brief This function is used to perform C2 Cipher operation on a block of data.
 *
 *        This function should be called after the CRYS_C2_Init function
 *        was called.
 *
 *        The function executes the following major steps:
 *
 *        1.Checks the validation of all of the inputs of the function.
 *          If one of the received parameters is not valid it shall return an error.
 *
 *          The major checkers that are run over the received parameters:
 *          - verifying that the context pointer is not DX_NULL (*ContextID_ptr).
 *          - verifying the pointer of the data_in buffer is not DX_NULL.
 *          - verifying that the pointer to the data_out buffer is not DX_NULL. 
 *          - verifying the values of the data_in buffers size is not 0 and a multiple of 8 bytes.
 *
 *        2.Decrypting the received context to the working context after 
 *          capturing the working context by calling the CRYS_CCM_GetContext() call.
 *        3.executing the C2 Cipher operation on the SW or HW by calling the 
 *          low level function LLF_C2_CipherBlock.
 *        4.Encrypting the information in the working context and storing it 
 *          to the users received context. After then the working context is released.
 *          This state is operated by calling the CRYS_CCM_ReleaseContext call.
 *        5.Exit the handler with the OK code.  
 *      
 *
 * @param[in] ContextID_ptr - A pointer to the C2 Cipher context buffer allocated by the user that
 *                            is used for the C2 operation. This should be the same context that was
 *                            used on the previous call of this session.
 *
 * @param[in] DataIn_ptr - The pointer to the buffer of the input data to the C2 Cipher. The pointer does 
 *                         not need to be aligned to 32 bits.
 *
 * @param[in] DataInSize - The size of the input data (must be not 0 and must be multiple of 8 bytes).
 *
 * @param[in/out] DataOut_ptr - The pointer to the buffer of the output data from the C2 Cipher. 
 *                              The pointer does not need to be aligned to 32 bits.  
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 */
 CEXPORT_C CRYSError_t  CRYS_C2_CipherBlock( 
                                CRYS_C2CipherUserContext_t       *ContextID_ptr,   
                                DxUint8_t                        *DataIn_ptr,     
                                DxUint32_t                        DataInSize,     
                                DxUint8_t                        *DataOut_ptr )
 {                              
   
   /* FUNCTION DECLARATIONS */

   /* The return error identifiers */
   CRYSError_t Error;
   
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;
 
   return Error;
   
 
}/* END OF CRYS_C2_CipherBlock */ 


/*****************************************************************************************************/
/**
 * @brief This function is used to end the C2 Cipher operation session.
 *
 *        It is the last function called on the C2 Cipher operation.
 *
 *        The function executes the following major steps:
 *
 *        1. Checks that the context pointer is not DX_NULL (*ContextID_ptr). . 
 *           If received parameter is not valid it shall return an error.
 *        2. Clearing the users context.
 *        3. Exits the handler with the OK code.
 *      
 *
 * @param[in] ContextID_ptr - a pointer to the C2_CIPHER context buffer allocated by the user that
 *                            was used on the previous call of this session.
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                        value from CRYS_C2_error.h
 */
CEXPORT_C CRYSError_t  CRYS_C2_CipherFree(CRYS_C2CipherUserContext_t  *ContextID_ptr )
{
   /* FUNCTION DECLARATIONS */

   /* The return error identifier */
   CRYSError_t Error;

   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;
 
   
   return Error; 

    
}/* END OF CRYS_C2_ipherFree */


/********************************************************************************************************/
/**
 * @brief This function is used to operate the C2 Cipher in one integrated operation.
 *
 *        The function simply sequential calls the C2_Cipher Init, Block and Finish functions.
 *
 * @param[in] Key_ptr - a pointer to the users key buffer.
 *
 * @param[in] EncryptDecryptFlag - This flag determains if the C2 shall perform an Encrypt operation [0] or a
 *                                 Decrypt operation [1].
 *
 * @param[in] OperationMode - The operation mode : ECB or CBC.
 *
 * @param[in] DataIn_ptr - The pointer to the buffer of the input data to the C2 Cipher.
 *                         The pointer does not need to be word-aligned.
 *
 * @param[in] DataInSize - The size of the input data (must be not 0 and must be multiple of 8 bytes).
 *
 * @param[in,out] DataOut_ptr - The pointer to the buffer of the output data from the C2 Cipher. 
 *                              The pointer does not need to be word-aligned.  
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 */
 CEXPORT_C CRYSError_t  CRYS_C2_Cipher(
                CRYS_C2_Key_t           *Key_ptr,                /* in */
                CRYS_C2_EncryptMode_t    EncryptDecryptFlag,     /* in */
                CRYS_C2_OperationMode_t  OperationMode,          /* in */   
                DxUint8_t               *DataIn_ptr,             /* in */ 
                DxUint32_t               DataInSize,             /* in */ 
                DxUint8_t               *DataOut_ptr )           /* in/out */ 
{ 
   
   /* FUNCTION DECLARATIONS */

   /* The return error identifier */
   CRYSError_t Error;
   

    /* FUNCTION LOGIC */
   
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;

   
   return Error;

   
}/* END OF CRYS_C2_Cipher */   

